/*
 * Decompiled with CFR 0.152.
 */
package pse.configuration;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import pse.configuration.Comment;
import pse.configuration.ConfigurationObject;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyObject
extends ConfigurationObject
implements Comparable<PropertyObject> {
    protected List<Comment> comments = new ArrayList<Comment>();
    protected String rawValue;
    protected String name;

    @Override
    public int compareTo(PropertyObject propertyObject) {
        return this.name.compareTo(propertyObject.getName());
    }

    public boolean shouldUseCData() {
        return false;
    }

    @Override
    public boolean hasAttributes() {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.comments.size() > 0;
    }

    @Override
    public boolean hasText() {
        return this.shouldUseCData() && this.nonEmptyString(this.rawValue);
    }

    public int getCommentsSize() {
        return this.comments.size();
    }

    public Comment getComment(int n) {
        return this.comments.get(n);
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void addComment(Comment comment) {
        this.comments.add(comment);
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public void setRawValue(String string) {
        this.rawValue = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addAttribute("name", this.name);
        if (!this.shouldUseCData()) {
            xmlWriter.addAttribute("value", this.rawValue);
        }
    }

    @Override
    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        for (Comment comment : this.comments) {
            this.addChild(xmlWriter, comment);
        }
    }

    @Override
    protected void addText(XmlWriter xmlWriter) {
        if (this.shouldUseCData()) {
            xmlWriter.addCData(this.rawValue);
        }
    }

    @Override
    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.name = XmlUtils.getAttribute(node, "name");
        if (!this.shouldUseCData()) {
            this.setRawValue(XmlUtils.getAttribute(node, "value"));
        }
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        List<Node> list = XmlUtils.getNodeChildren(node, "comment");
        for (Node node2 : list) {
            this.addComment((Comment)this.readChildFromChildNode(node2, new Comment()));
        }
    }

    @Override
    protected void readText(Node node) {
        if (this.shouldUseCData()) {
            this.setRawValue(XmlUtils.getTransitiveText(node));
        }
    }
}

